/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletTerminatingException;
import com.ibm.hwmca.fw.tasklet.impl.response.ErrorResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.TerminateResponseData;
import com.ibm.hwmca.fw.util.Trace;

public class PanelTaskletRequest
extends TaskletRequest {
    private static final String TRACE_MASKT = "XTSKOPRT";
    private static final String TRACE_MASKF = "XTSKOPRF";
    private static final String TRACE_MASKD = "XTSKOPRD";
    private boolean synchronousRequest = false;
    private PanelTaskletResponse synchronousResponse = null;

    public PanelTaskletRequest(Object source) {
        super(source);
        Trace.trace(TRACE_MASKF, "[PanelTaskletRequest] <init>");
    }

    public PanelTaskletRequest() {
        Trace.trace(TRACE_MASKF, "[PanelTaskletRequest] <init>");
    }

    public void setDisposed() {
        Trace.trace(TRACE_MASKF, "[PanelTaskletRequest] setDisposed()");
        this.setMode(2);
    }

    public boolean isDisposed() {
        return this.mode == 2;
    }

    public boolean isSynchronous() {
        return this.synchronousRequest;
    }

    synchronized PanelTaskletResponse getResponse() throws TaskletTerminatingException {
        if (!this.isSynchronous()) {
            throw new IllegalStateException("Method only appropriate for synchronous requests");
        }
        while (true) {
            if (this.synchronousResponse != null) {
                if (this.synchronousResponse.getResponseData() instanceof TerminateResponseData || this.synchronousResponse.getResponseData() instanceof ErrorResponseData) {
                    throw new TaskletTerminatingException("Tasklet client has been asked to terminate.");
                }
                return this.synchronousResponse;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void setResponse(PanelTaskletResponse synchronousResponse) {
        this.synchronousResponse = synchronousResponse;
        this.notifyAll();
    }

    void setSynchronous(boolean value) {
        this.synchronousRequest = value;
    }

    public void setCanceled() {
        Trace.trace(TRACE_MASKF, "[PanelTaskletRequest] setCanceled()");
        this.setMode(1);
    }

    public boolean isCanceled() {
        return this.mode == 1;
    }

    public String toString() {
        return "PanelTaskletRequest[Mode=" + PanelTaskletRequest.modeToString(this.mode) + "]";
    }

    public void captureDebugInformation(StringBuffer sb) {
        sb.append("\tsynchronousRequest = ").append(this.synchronousRequest).append("\n");
        sb.append("\tsynchronousResponse = ").append(this.synchronousResponse).append("\n");
        super.captureDebugInformation(sb);
    }

    public void debugToTrace() {
        Trace.trace("XTSK---F", "\tsynchronousRequest = " + this.synchronousRequest);
        Trace.trace("XTSK---F", "\tsynchronousResponse = " + this.synchronousResponse);
        super.debugToTrace();
    }
}

